package chess4j;

import java.text.ParseException;


import org.xml.sax.SAXException;

import chess4j.board.Board;
import chess4j.io.FenParser;
import chess4j.utils.Perft;

public class PerftTest {

	//@Test
	public void perftTest1() {
		long start = System.currentTimeMillis();
		String fen="rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq -";
		long n=0;
		try {
			Board b = App.getBoard().deepCopy();
			FenParser.setPos(b, fen);
			n = Perft.perft(b,6,null);
		} catch (ParseException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (SAXException e) {
			e.printStackTrace();
			System.exit(1);
		}
		System.out.println("nodes: " + n);
		long end = System.currentTimeMillis();
		System.out.println("elapsed time: " + (end-start) + " ms");
		System.out.println("rate: " + n*1000/(end-start) + " n/s\n");
		assert(n==124132537);
	}
	
	//@Test
	public void perftTest2() {
		long start = System.currentTimeMillis();
		String fen="r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R w KQkq -";
		long n=0;
		try {
			Board b = App.getBoard().deepCopy();
			FenParser.setPos(b, fen);			
			n = Perft.perft(b,5,null);
		} catch (ParseException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (SAXException e) {
			e.printStackTrace();
			System.exit(1);
		}
		System.out.println("nodes: " + n);
		long end = System.currentTimeMillis();
		System.out.println("elapsed time: " + (end-start) + " ms");
		System.out.println("rate: " + n*1000/(end-start) + " n/s\n");
		assert(n==197876243);
	}
}
